% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/net.3dplot.R
\name{net.3dplot}
\alias{net.3dplot}
\title{3D network plot of an adjacency matrix between pairs of change points}
\usage{
net.3dplot(adjmatrix, communities = NULL, colors = NULL)
}
\arguments{
\item{adjmatrix}{A numerical matrix of dimension 333*333 (Gordon atlas). This is the adjacency matrix to be plotted.}

\item{communities}{A vector of character strings specifying the communities to plot. By default, all communities are plotted. Communities available are:
"Default", "SMhand", "SMmouth", "Visual", "FrontoParietal", "Auditory", "None", "CinguloParietal", "RetrosplenialTemporal", "CinguloOperc",
"VentralAttn", "Salience", and "DorsalAttn".}

\item{colors}{A vector of character strings specifying the hex codes for node colors to distinguish each community. By default, each community is given
a predefined, unique color.}
}
\value{
A 3D network plot of an adjacency matrix between pairs of change points.
}
\description{
This function takes a Gordon atlas defined adjacency matrix and returns a 3D plot of it.
}
\examples{
## Plotting a 333 * 333 adjacency matrix "adjmatrix" with default settings
\donttest{net.3dplot(adjmatrix)}

## Plotting a 333 * 333 adjacency matrix "adjmatrix" with default colours but only
## the "Visual", "FrontoParietal", and "Auditory" communities
comms = c("Visual", "FrontoParietal", "Auditory")
\donttest{net.3dplot(adjmatrix, communities = comms)}

## Plotting a 333 * 333 adjacency matrix "adjmatrix" with red, blue, and green
## nodes to denote the "Default", "SMhand", and "Visual" communities
comms = c("Default", "SMhand", "Visual")
colrs = c("#FF0000", "#00FF00", "#0000FF")
\donttest{net.3dplot(adjmatrix, communities = comms, colors = colrs)}

## The default color palette is defined as follows
## c("#D32F2F", "#303F9F", "#388E3C", "#FFEB3B", "#03A9F4", "#FF9800", "#673AB7",
## "#CDDC39", "#9C27B0", "#795548", "#212121", "#009688", "#FFC0CB")

}
\references{
"Factorized Binary Search: a novel technique for change point detection in multivariate high-dimensional time series networks", Ondrus et al.
(2021), preprint.
}
\author{
Martin Ondrus, \email{mondrus@ualberta.ca}, Ivor Cribben, \email{cribben@ualberta.ca}
}
