% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var.R
\name{VAR}
\alias{VAR}
\alias{report.VAR}
\title{Estimate a VAR model}
\usage{
VAR(formula, ic = c("aicc", "aic", "bic"), ...)
}
\arguments{
\item{formula}{Model specification (see "Specials" section).}

\item{ic}{The information criterion used in selecting the model.}

\item{...}{Further arguments for arima}
}
\value{
A model specification.
}
\description{
Searches through the vector of lag orders to find the best VAR model which
has lowest AIC, AICc or BIC value. It is implemented using OLS per equation.
}
\details{
Exogenous regressors and \code{\link{common_xregs}} can be specified in the model
formula.
}
\section{Specials}{


\subsection{pdq}{
The \code{AR} special is used to specify the lag order for the auto-regression.
\preformatted{
AR(p = 0:5)
}

\tabular{ll}{
\code{p}        \tab The order of the auto-regressive (AR) terms. If multiple values are provided, the one which minimises \code{ic} will be chosen.\cr
}
}

\subsection{xreg}{
Exogenous regressors can be included in an ARIMA model without explicitly using the \code{xreg()} special. Common exogenous regressor specials as specified in \code{\link{common_xregs}} can also be used. These regressors are handled using \code{\link[stats:model.frame]{stats::model.frame()}}, and so interactions and other functionality behaves similarly to \code{\link[stats:lm]{stats::lm()}}.

The inclusion of a constant in the model follows the similar rules to \code{\link[stats:lm]{stats::lm()}}, where including \code{1} will add a constant and \code{0} or \code{-1} will remove the constant. If left out, the inclusion of a constant will be determined by minimising \code{ic}.

\preformatted{
xreg(...)
}

\tabular{ll}{
\code{...}      \tab Bare expressions for the exogenous regressors (such as \code{log(x)})
}
}
}

\examples{

lung_deaths <- cbind(mdeaths, fdeaths) \%>\%
  as_tsibble(pivot_longer = FALSE)

fit <- lung_deaths \%>\%
  model(VAR(vars(mdeaths, fdeaths) ~ AR(3)))

report(fit)

fit \%>\%
  forecast() \%>\%
  autoplot(lung_deaths)
}
\seealso{
\href{https://otexts.com/fpp2/VAR.html}{Forecasting: Principles and Practices, Vector autoregressions (section 11.2)}
}
