% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_combination.R
\name{combination_model}
\alias{combination_model}
\title{Combination modelling}
\usage{
combination_model(..., cmbn_fn = combination_ensemble, cmbn_args = list())
}
\arguments{
\item{...}{Model definitions used in the combination.}

\item{cmbn_fn}{A function used to produce the combination.}

\item{cmbn_args}{Additional arguments passed to \code{cmbn_fn}.}
}
\description{
Combines multiple model definitions (passed via \code{...}) to produce a model
combination definition using some combination function (\code{cmbn_fn}). Currently
distributional forecasts are only supported for models producing normally
distributed forecasts.
}
\details{
A combination model can also be produced using mathematical operations.
}
\examples{
if (requireNamespace("fable", quietly = TRUE)) {
library(fable)
library(tsibble)
library(tsibbledata)

# cmbn1 and cmbn2 are equivalent and equally weighted.
aus_production \%>\%
  model(
    cmbn1 = combination_model(SNAIVE(Beer), TSLM(Beer ~ trend() + season())),
    cmbn2 = (SNAIVE(Beer) + TSLM(Beer ~ trend() + season()))/2
  )

# An inverse variance weighted ensemble.
aus_production \%>\%
  model(
    cmbn1 = combination_model(
      SNAIVE(Beer), TSLM(Beer ~ trend() + season()), 
      cmbn_args = list(weights = "inv_var")
    )
  )
}
}
