% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/broom.R
\name{augment.mdl_df}
\alias{augment.mdl_df}
\alias{augment.mdl_ts}
\title{Augment a mable}
\usage{
\method{augment}{mdl_df}(x, ...)

\method{augment}{mdl_ts}(x, type = NULL, ...)
}
\arguments{
\item{x}{A mable.}

\item{...}{Arguments for model methods.}

\item{type}{Deprecated.}
}
\description{
Uses a fitted model to augment the response variable with fitted values and
residuals.
}
\examples{
if (requireNamespace("fable", quietly = TRUE)) {
library(fable)
library(tsibbledata)

# Forecasting with an ETS(M,Ad,A) model to Australian beer production
aus_production \%>\%
  model(ets = ETS(log(Beer) ~ error("M") + trend("Ad") + season("A"))) \%>\% 
  augment()
}

}
