% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_binary_icc.R
\name{draw_binary_icc}
\alias{draw_binary_icc}
\title{Draw binary data with fixed intra-cluster correlation.}
\usage{
draw_binary_icc(prob = 0.5, N = NULL, clusters, ICC = 0)
}
\arguments{
\item{prob}{A number or vector of numbers, one probability per cluster. If none
is provided, will default to 0.5.}

\item{N}{(Optional) A number indicating the number of observations to be
generated. Must be equal to length(clusters) if provided.}

\item{clusters}{A vector of factors or items that can be coerced to
clusters; the length will determine the length of the generated data.}

\item{ICC}{A number indicating the desired \code{ICC}, if none is provided
the default ICC will be 0.}
}
\value{
A vector of binary numbers corresponding to the observations from
the supplied cluster IDs.
}
\description{
Data is generated to ensure inter-cluster correlation 0, intra-cluster
correlation in expectation ICC. Algorithm taken from Hossein,
Akhtar. "ICCbin: An R Package Facilitating Clustered Binary Data
Generation, and Estimation of Intracluster Correlation Coefficient (ICC)
for Binary Data".
}
\examples{
# Divide units into clusters
clusters = rep(1:5, 10)

# Default probability 0.5, default ICC 0
draw_binary_icc(clusters = clusters)

# Specify probability or ICC
corr_draw = draw_binary_icc(prob = 0.5, clusters = clusters, ICC = 0.5)

# Verify ICC of data.
summary(lm(corr_draw ~ as.factor(clusters)))$r.squared

}
