% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{stackplot}
\alias{stackplot}
\title{Plots}
\usage{
stackplot(mat, col, legend, log.y = FALSE, perc = F, qt = 100, ...)
}
\arguments{
\item{mat}{A population matrix, as produced by \code{\link{abundance.matrix}} or something that
can be coerced to matrix}

\item{col}{Optional. A color vector}

\item{legend}{Optional. An array of names}

\item{log.y}{Logical. Should the y-axis be plotted in a logarithmic scale?}

\item{perc}{Logical. If set to true, will output the y-axis as a percentage instead of the absolute numbers}

\item{qt}{Optional. For distributions, show only up to quantile qt (percentage)}

\item{\dots}{Further parameters to be passed to the lower level plot function}
}
\description{
Plotting functions.
}
\details{
The \code{stackplot} function produces a stacked plot of the population over time.
Notice that the population should have at least two stages for this function to work.
}
\examples{
data(twospecies)
ab <- abundance.matrix(twospecies,seq(0,twospecies$maxtime,by=1))
# species 1
stackplot(ab[,1:3])
# species 2
stackplot(ab[,4:5])
}
