% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fviz_cluster.R
\name{fviz_cluster}
\alias{fviz_cluster}
\title{Visualize Clustering Results}
\usage{
fviz_cluster(object, data = NULL, stand = TRUE, geom = c("point", "text"),
  repel = FALSE, show.clust.cent = TRUE, frame = TRUE,
  frame.type = "convex", frame.level = 0.95, frame.alpha = 0.2,
  pointsize = 2, labelsize = 4, title = "Cluster plot",
  jitter = list(what = "label", width = NULL, height = NULL),
  outlier.color = "black", outlier.shape = 19)
}
\arguments{
\item{object}{an object of class "partition" created by the functions pam(),
clara() or fanny() in cluster package; "kmeans" [in stats package]; "dbscan"
[in fpc package]; "Mclust" [in mclust]; "hkmeans", "eclust" [in factoextra].
Possible value are also any list object with data and cluster components 
(e.g.: object = list(data = mydata, cluster = myclust)).}

\item{data}{the data that has been used for clustering. Required only when
object is a class of kmeans or dbscan.}

\item{stand}{logical value; if TRUE, data is standardized before principal
component analysis}

\item{geom}{a text specifying the geometry to be used for the graph. Allowed
values are the combination of c("point", "text"). Use "point" (to show only
points);  "text" to show only labels; c("point", "text") to show both types.}

\item{repel}{a boolean, whether to use ggrepel to avoid overplotting text 
labels or not.}

\item{show.clust.cent}{logical; if TRUE, shows cluster centers}

\item{frame}{logical value; if TRUE, draws outline around points of each
cluster}

\item{frame.type}{Character specifying frame type. Possible values are
'convex' or types supporeted by \code{ggplot2::stat_ellipse} including one
of c("t", "norm", "euclid").}

\item{frame.level}{Passed for \code{ggplot2::stat_ellipse} 's level. Ignored
in 'convex'. Default value is 0.95.}

\item{frame.alpha}{Alpha for frame specifying the transparency level of fill
color.}

\item{pointsize}{the size of points}

\item{labelsize}{font size for the labels}

\item{title}{the title of the graph}

\item{jitter}{a parameter used to jitter the points in order to reduce
overplotting. It's a list containing the objects what, width and height (i.e
jitter = list(what, width, height)). \itemize{ \item what: the element to be
jittered. Possible values are "point" or "p"; "label" or "l"; "both" or "b".
\item width: degree of jitter in x direction \item height: degree of jitter
in y direction }}

\item{outlier.color, outlier.shape}{the color and the shape of outliers. 
Outliers can be detected only in DBSCAN clustering.}
}
\value{
return a ggpplot.
}
\description{
Provides ggplot2-based elegant visualization of partitioning
methods including kmeans [stats package]; pam, clara and fanny [cluster
package]; dbscan [fpc package]; Mclust [mclust package]; HCPC [FactoMineR];
hkmeans [factoextra]. Observations are represented by points in the plot,
using principal components if ncol(data) > 2. An ellipse is drawn around each
cluster.
}
\examples{
set.seed(123)

# Data preparation
# +++++++++++++++
data("iris")
head(iris)
# Remove species column (5) and scale the data
iris.scaled <- scale(iris[, -5])

# K-means clustering
# +++++++++++++++++++++
km.res <- kmeans(iris.scaled, 3, nstart = 25)

# Visualize kmeans clustering
# use repel = TRUE to avoid overplotting
fviz_cluster(km.res, iris[, -5], frame.type = "norm")


# Change the color and theme
fviz_cluster(km.res, iris[, -5]) + 
 scale_color_brewer(palette = "Set2")+
 scale_fill_brewer(palette = "Set2") +
 theme_minimal()
 
 \dontrun{
# Show points only
fviz_cluster(km.res, iris[, -5], geom = "point")
# Show text only
fviz_cluster(km.res, iris[, -5], geom = "text")
 
# PAM clustering
# ++++++++++++++++++++
require(cluster)
pam.res <- pam(iris.scaled, 3)
 # Visualize pam clustering
fviz_cluster(pam.res, geom = "point", frame.type = "norm")
}

# Hierarchical clustering
# ++++++++++++++++++++++++
# Use hcut() which compute hclust and cut the tree
hc.cut <- hcut(iris.scaled, k = 3, hc_method = "complete")
# Visualize dendrogram
fviz_dend(hc.cut, show_labels = FALSE, rect = TRUE)
# Visualize cluster
fviz_cluster(hc.cut, frame.type = "convex")



}
\author{
Alboukadel Kassambara \email{alboukadel.kassambara@gmail.com}
}
\seealso{
\code{\link{fviz_silhouette}}, \code{\link{hcut}},
 \code{\link{hkmeans}},  \code{\link{eclust}}, \code{\link{fviz_dend}}
}

