% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities_fsvdraws.R
\name{predh}
\alias{predh}
\title{Predicts factor and idiosyncratic log-volatilities h}
\usage{
predh(x, ahead = 1, each = 1)
}
\arguments{
\item{x}{Object of class \code{'fsvdraws'}, usually resulting from a call
to \code{\link{fsvsample}}.}

\item{ahead}{Vector of timepoints, indicating how many steps
to predict ahead.}

\item{each}{Single integer (or coercible to such) indicating how
often should be drawn from the posterior predictive distribution
for each draw that has been stored during MCMC sampling.}
}
\value{
List of class \code{fsvpredh} containing two elements:
\itemize{
\item{idih}{Array containing the draws of the latent idiosyncratic
log-volatilities.}
\item{factorh}{Array containing the draws of the latent factor
log-volatilities.}
}
}
\description{
\code{predh} simulates from the posterior predictive distribution
of the latent log-variances h, both for factors as well as for 
idiosyncratic series.
}
\examples{
\donttest{
set.seed(1)
sim <- fsvsim(series = 3, factors = 1) # simulate 
res <- fsvsample(sim$y, factors = 1) # estimate

# Predict 1, 10, and 100 days ahead:
predobj <- predh(res, ahead = c(1, 10, 100))

# Trace plot of draws from posterior predictive factor log-variance
# (one, ten, and 100 days ahead):
plot.ts(predobj$factorh[1,,])

# Smoothed kernel density estimates of predicted volas:
plot(density(exp(predobj$factorh[1,,"1"]/2), adjust = 2))
lines(density(exp(predobj$factorh[1,,"10"]/2), adjust = 2), col = 2)
lines(density(exp(predobj$factorh[1,,"100"]/2), adjust = 2), col = 3)
}

}
\seealso{
Other predictors: 
\code{\link{predcond}()},
\code{\link{predcor}()},
\code{\link{predcov}()},
\code{\link{predloglikWB}()},
\code{\link{predloglik}()},
\code{\link{predprecWB}()}
}
\concept{predictors}
