% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{facloadpairplot}
\alias{facloadpairplot}
\title{Displays bivariate marginal posterior distributions of factor loadings.}
\usage{
facloadpairplot(x, maxpoints = 500, alpha = 20/maxpoints, cex = 3)
}
\arguments{
\item{x}{Object of class \code{'fsvdraws'}, usually resulting from a call
to \code{\link{fsvsample}}.}

\item{maxpoints}{The maximum amount of posterior draws to plot. If
the number of draws stored in \code{x} exceeds this number, draws are
thinned accordingly.}

\item{alpha}{Level of transparency.}

\item{cex}{Controls the size of the dots.}
}
\value{
Returns \code{x} invisibly.
}
\description{
\code{facloadpairplot} illustrates the bivariate marginals of the 
factor loadings distribution. For a monochrome variant, see
\code{\link{facloadcredplot}}.
}
\seealso{
Other plotting: \code{\link{comtimeplot}},
  \code{\link{corimageplot}}, \code{\link{corplot}},
  \code{\link{cortimeplot}}, \code{\link{facloadcredplot}},
  \code{\link{facloaddensplot}},
  \code{\link{facloadpointplot}},
  \code{\link{facloadtraceplot}},
  \code{\link{logvartimeplot}},
  \code{\link{paratraceplot}}, \code{\link{plot.fsvdraws}},
  \code{\link{plotalot}}, \code{\link{voltimeplot}}
}
\concept{plotting}
