% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_api.R
\docType{class}
\name{UtilityApi}
\alias{UtilityApi}
\title{Utility operations}
\format{An \code{R6Class} generator object}
\description{
factset.analyticsapi.engines
}
\section{Methods}{

\describe{
\strong{ GetByUrl } \emph{ Url of the GET endpoint }
This function can be used to fetch data from any Get endpoint.

\itemize{
\item \emph{ @param } url character
\item \emph{ @returnType } raw  

\item On encountering errors, an error of subclass ApiException will be thrown.

\item status code : 200 | Expected response once the request is successful. Response body will contain the data.

\item return type : raw 
\item response headers :

\tabular{ll}{
X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
X-DataDirect-Request-Key \tab FactSet’s request key header. \cr
}
\item status code : 400 | Invalid identifier provided.


\item response headers :

\tabular{ll}{
X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
X-DataDirect-Request-Key \tab FactSet’s request key header. \cr
}
\item status code : 401 | Missing or invalid authentication.


\item response headers :

\tabular{ll}{
X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
X-DataDirect-Request-Key \tab FactSet’s request key header. \cr
}
\item status code : 403 | User is forbidden with current credentials


\item response headers :

\tabular{ll}{
X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
X-DataDirect-Request-Key \tab FactSet’s request key header. \cr
}
\item status code : 406 | Unsupported Accept header.


\item response headers :

\tabular{ll}{
X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
X-DataDirect-Request-Key \tab FactSet’s request key header. \cr
}
\item status code : 500 | Server error. Log the X-DataDirect-Request-Key header to assist in troubleshooting.


\item response headers :

\tabular{ll}{
X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
X-DataDirect-Request-Key \tab FactSet’s request key header. \cr
}
\item status code : 503 | Request timed out. Retry the request in sometime.


\item response headers :

\tabular{ll}{
X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
X-DataDirect-Request-Key \tab FactSet’s request key header. \cr
}
}

}
}

\examples{
\dontrun{
####################  GetByUrl  ####################

library(factset.analyticsapi.engines)
var.url <- url # character | Url of the GET endpoint

# Get by url
api.instance <- UtilityApi$new()

#Configure HTTP basic authorization: Basic
# provide your username in the user-serial format
api.instance$apiClient$username <- '<user-serial>'; 
# provide your api key generated using the developer portal
api.instance$apiClient$password <- '<api_key>';

result <- tryCatch(
            api.instance$GetByUrl(url = var.url),
            ApiException = function(ex) ex 
         )
# In case of error, print the error object 
if(!is.null(result$ApiException)) {
  cat(result$ApiException$toString())
} else {
# deserialized response object
response.object <- result$content
# response headers
response.headers <- result$response$headers
# response status code
response.status.code <- result$response$status_code
}


}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{apiClient}}{Handles the client-server communication.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{UtilityApi$new()}}
\item \href{#method-GetByUrl}{\code{UtilityApi$GetByUrl()}}
\item \href{#method-GetByUrlWithHttpInfo}{\code{UtilityApi$GetByUrlWithHttpInfo()}}
\item \href{#method-clone}{\code{UtilityApi$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UtilityApi$new(apiClient)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GetByUrl"></a>}}
\subsection{Method \code{GetByUrl()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UtilityApi$GetByUrl(url, ...)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GetByUrlWithHttpInfo"></a>}}
\subsection{Method \code{GetByUrlWithHttpInfo()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UtilityApi$GetByUrlWithHttpInfo(url, ...)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UtilityApi$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
