% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_fairness_object.R
\name{plot.fairness_object}
\alias{plot.fairness_object}
\title{Plot fairness object}
\usage{
\method{plot}{fairness_object}(x, ...)
}
\arguments{
\item{x}{\code{fairness_object} object}

\item{...}{other plot parameters}
}
\value{
\code{ggplot2} object
}
\description{
Plot fairness check enables to look how big differences are between base subgroup (privileged) and unprivileged ones.
If bar plot reaches red zone it means that for this subgroup fairness goal is not satisfied. Multiple subgroups and models can be plotted.
Red and green zone boundary can be moved through epsilon parameter, that needs to be passed through \code{fairness_check}.
}
\examples{

data("german")

y_numeric <- as.numeric(german$Risk) -1

lm_model <- glm(Risk~.,
                data = german,
                family=binomial(link="logit"))

explainer_lm <- DALEX::explain(lm_model, data = german[,-1], y = y_numeric)

fobject <- fairness_check(explainer_lm,
                          protected = german$Sex,
                          privileged = "male")
plot(fobject)

\donttest{
rf_model <- ranger::ranger(Risk ~.,
                           data = german,
                           probability = TRUE,
                           max.depth = 3,
                           num.trees = 100,
                           seed = 1)


explainer_rf <- DALEX::explain(rf_model,
                               data = german[,-1],
                               y = y_numeric)

fobject <- fairness_check(explainer_rf, fobject)

plot(fobject)
}

}
