/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis;

import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MaxIterationsExceededException;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.analysis.UnivariateRealIntegratorImpl;

public class TrapezoidIntegrator
extends UnivariateRealIntegratorImpl {
    private static final long serialVersionUID = 4978222553983172543L;
    private double s;

    public TrapezoidIntegrator(UnivariateRealFunction f) {
        super(f, 64);
    }

    double stage(double min, double max, int n) throws FunctionEvaluationException {
        double sum = 0.0;
        if (n == 0) {
            this.s = 0.5 * (max - min) * (this.f.value(min) + this.f.value(max));
            return this.s;
        }
        long np = 1L << n - 1;
        double spacing = (max - min) / (double)np;
        double x = min + 0.5 * spacing;
        for (long i = 0L; i < np; ++i) {
            sum += this.f.value(x);
            x += spacing;
        }
        this.s = 0.5 * (this.s + sum * spacing);
        return this.s;
    }

    public double integrate(double min, double max) throws MaxIterationsExceededException, FunctionEvaluationException, IllegalArgumentException {
        this.clearResult();
        this.verifyInterval(min, max);
        this.verifyIterationCount();
        double oldt = this.stage(min, max, 0);
        for (int i = 1; i <= this.maximalIterationCount; ++i) {
            double t = this.stage(min, max, i);
            if (i >= this.minimalIterationCount && Math.abs(t - oldt) <= Math.abs(this.relativeAccuracy * oldt)) {
                this.setResult(t, i);
                return this.result;
            }
            oldt = t;
        }
        throw new MaxIterationsExceededException(this.maximalIterationCount);
    }

    protected void verifyIterationCount() throws IllegalArgumentException {
        super.verifyIterationCount();
        if (this.maximalIterationCount > 64) {
            throw new IllegalArgumentException("Iteration upper limit out of [0, 64] range: " + this.maximalIterationCount);
        }
    }
}

