% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_flow_percentile.R
\name{calc_flow_percentile}
\alias{calc_flow_percentile}
\title{Calculate the percentile rank of a flow value}
\usage{
calc_flow_percentile(
  data,
  dates = Date,
  values = Value,
  groups = STATION_NUMBER,
  station_number,
  roll_days = 1,
  roll_align = "right",
  flow_value,
  water_year_start = 1,
  start_year,
  end_year,
  exclude_years,
  complete_years = FALSE,
  months = 1:12
)
}
\arguments{
\item{data}{Data frame of daily data that contains columns of dates, flow values, and (optional) groups (e.g. station numbers).
Leave blank if using \code{station_number} argument.}

\item{dates}{Name of column in \code{data} that contains dates formatted YYYY-MM-DD. Only required if dates column name is not 
'Date' (default). Leave blank if using \code{station_number} argument.}

\item{values}{Name of column in \code{data} that contains numeric flow values, in units of cubic metres per second.
Only required if values column name is not 'Value' (default). Leave blank if using \code{station_number} argument.}

\item{groups}{Name of column in \code{data} that contains unique identifiers for different data sets, if applicable. Only required 
if groups column name is not 'STATION_NUMBER'. Function will automatically group by a column named 'STATION_NUMBER' if 
present. Remove the 'STATION_NUMBER' column beforehand to remove this grouping. Leave blank if using \code{station_number} 
argument.}

\item{station_number}{Character string vector of seven digit Water Survey of Canada station numbers (e.g. \code{"08NM116"}) of
which to extract daily streamflow data from a HYDAT database. Requires \code{tidyhydat} package and a HYDAT database.
Leave blank if using \code{data} argument.}

\item{roll_days}{Numeric value of the number of days to apply a rolling mean. Default \code{1}.}

\item{roll_align}{Character string identifying the direction of the rolling mean from the specified date, either by the first 
(\code{'left'}), last (\code{'right'}), or middle (\code{'center'}) day of the rolling n-day group of observations. 
Default \code{'right'}.}

\item{flow_value}{A numeric flow value of which to determine the percentile rank. Required.}

\item{water_year_start}{Numeric value indicating the month (\code{1} through \code{12}) of the start of water year for
analysis. Default \code{1}.}

\item{start_year}{Numeric value of the first year to consider for analysis. Leave blank to use the first year of the source data.}

\item{end_year}{Numeric value of the last year to consider for analysis. Leave blank to use the last year of the source data.}

\item{exclude_years}{Numeric vector of years to exclude from analysis. Leave blank to include all years.}

\item{complete_years}{Logical values indicating whether to include only years with complete data in analysis. Default \code{FALSE}.}

\item{months}{Numeric vector of months to include in analysis (e.g. \code{6:8} for Jun-Aug). Leave blank to summarize 
all months (default \code{1:12}).}
}
\value{
A tibble data frame, or a single numeric value if no station number provided, of the percentile rank of a given flow value.
}
\description{
Calculates the percentile rank of a discharge value compared to all flow values of a streamflow data set. 
   Looks up the value in the distribution (\code{stats::ecdf()} function) of all daily discharge values from all years, unless
   specified. Returns a tibble with statistics.
}
\examples{
# Run if HYDAT database has been downloaded (using tidyhydat::download_hydat())
if (file.exists(tidyhydat::hy_downloaded_db())) {

# Calculate the percentile rank of a 10-cms flow value from a full record
calc_flow_percentile(station_number = "08NM116", 
                     flow_value = 10)

# Calculate the percentile rank of a 10-cms flow value from years with no missing data
calc_flow_percentile(station_number = "08NM116", 
                     complete_years = TRUE,
                     flow_value = 10)
                     
# Calculate the percentile rank of a 10-cms flow value for June from years with no missing data
calc_flow_percentile(station_number = "08NM116", 
                     complete_years = TRUE,
                     months = 6,
                     flow_value = 10)
                     
}
}
