% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adaboost_real.R
\name{real_adaboost}
\alias{real_adaboost}
\title{Real Adaboost algorithm}
\usage{
real_adaboost(formula, data, nIter, ...)
}
\arguments{
\item{formula}{Formula for models}

\item{data}{Input dataframe}

\item{nIter}{no. of classifiers}

\item{...}{other optional arguments, not implemented now}
}
\value{
object of class real_adaboost
}
\description{
Implements Zhu et al's real adaboost or SAMME.R algorithm
}
\details{
This implements the real adaboost algorithm for a binary classification 
task. The target variable must be a factor with exactly two levels.
The final classifier is a linear combination of weak decision tree
classifiers. Real adaboost uses the class probabilities of the weak classifiers
to iteratively update example weights. It has been found to have lower
generalization errors than adaboost.m1 for the same number of iterations.
}
\examples{
fakedata <- data.frame( X=c(rnorm(100,0,1),rnorm(100,1,1)), Y=c(rep(0,100),rep(1,100) ) )
fakedata$Y <- factor(fakedata$Y)
test_adaboost <- real_adaboost(Y~X, data=fakedata,10)
}
\references{
Zhu, Ji, et al. \dQuote{Multi-class adaboost} \emph{Ann Arbor} 1001.48109 (2006): 1612.
}
\seealso{
\code{\link{adaboost}},\code{\link{predict.real_adaboost}}
}

