#' Sample dataset A
#'
#' This data is a randomized and anonymized sample dataset
#' to display features of fastLink.
#'
#' @name dfA
#' @docType data
#' @format A dataframe containing 500 observations.
#' @keywords dataset
"dfA"

#' Sample dataset B
#'
#' This data is a randomized and anonymized sample dataset
#' to display features of fastLink.
#'
#' @name dfB
#' @docType data
#' @format A dataframe containing 350 observations.
#' @keywords dataset
"dfB"


#' County-level FIPS Codes
#'
#' This data maps county names to FIPS codes for
#' use in calculating prior movers rates.
#'
#' @name countyfips
#' @docType data
#' @format A dataframe containing 3235 observations.
#' @keywords dataset
"countyfips"

#' State-level FIPS Codes
#'
#' This data maps state names to FIPS codes for
#' use in calculating prior movers rates.
#'
#' @name statefips
#' @docType data
#' @format A dataframe containing 54 observations.
#' @keywords dataset
"statefips"

#' In-state movers rates by state
#'
#' This data collects in-state movers rates by state,
#' for imputation where within-county movers rates are
#' not available.
#'
#' @name statemove
#' @docType data
#' @format A dataframe containing 51 observations.
#' @keywords dataset
"statemove"

#' County-level inflow rates by state
#'
#' This data compiles and cleans county-level
#' movers inflow rates by county, from the IRS
#' Statistics on Income dataset.
#'
#' @name countyinflow
#' @docType data
#' @format A dataframe containing 423752 observations.
#' @keywords dataset
"countyinflow"

#' County-level outflow rates by state
#'
#' This data compiles and cleans county-level
#' movers outflow rates by county, from the IRS
#' Statistics on Income dataset.
#'
#' @name countyoutflow
#' @docType data
#' @format A dataframe containing 424475 observations.
#' @keywords dataset
"countyoutflow"

#' State-level inflow rates by state
#'
#' This data compiles and cleans state-level
#' movers inflow rates by state, from the IRS
#' Statistics on Income dataset.
#'
#' @name stateinflow
#' @docType data
#' @format A dataframe containing 11321 observations.
#' @keywords dataset
"stateinflow"

#' State-level outflow rates by state
#'
#' This data compiles and cleans state-level
#' movers outflow rates by state, from the IRS
#' Statistics on Income dataset.
#'
#' @name stateoutflow
#' @docType data
#' @format A dataframe containing 11320 observations.
#' @keywords dataset
"stateoutflow"

