% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.fastNaiveBayes.bernoulli.R
\name{predict.fastNaiveBayes.bernoulli}
\alias{predict.fastNaiveBayes.bernoulli}
\title{Predict Method for fastNaiveBayes.bernoulli fits}
\usage{
\method{predict}{fastNaiveBayes.bernoulli}(object, newdata,
  type = c("class", "raw", "rawprob"), sparse = FALSE, ...)
}
\arguments{
\item{object}{A fitted object of class "fastNaiveBayes.bernoulli".}

\item{newdata}{A numeric matrix with 1's and 0's to indicate the presence or absence of features. A Sparse dgcMatrix is also accepted.
Note that if newdata contains features that were not encountered in the training data, these are omitted from the prediction.
Furthermore, newdata can contain fewer features than encountered in the training data. In this case, newdata will be padded with
extra columns all filled with 0's.}

\item{type}{If "raw", the conditional a-posterior probabilities for each class are returned, and the class with maximal probability else.}

\item{sparse}{Use a sparse Matrix? If true a sparse matrix will be constructed from x, which can give up to a 40\% speed up.
It's possible to directly feed a sparse dgcMatrix as x, which will set this parameter to TRUE}

\item{...}{Not used.}
}
\value{
If type = 'class', a factor with classified class levels. If type = 'raw', a matrix with the predicted probabilities of
    each class, where each column in the matrix corresponds to a class level.
}
\description{
Uses a fastNaiveBayes.bernoulli model and a new data set to create the classifications.
    This can either be the raw probabilities generated by the fastNaiveBayes.bernoulli model or the classes themselves.
}
\details{
In the extremely unlikely case that two classes have the exact same estimated probability, the first encountered class
    is used as the classification and a warning is issued.

    Using a sparse matrix directly can be especially useful if it's necessary to use predict multiple times on the same matrix or
    on different subselections of the same initial matrix, see examples for further details.
}
\examples{
    rm(list=ls())
    require(mlbench)
    require(Matrix)

    # Load BreastCancer data
    data(BreastCancer)
    dim(BreastCancer)
    levels(BreastCancer$Class)
    head(BreastCancer)

    # Bernoulli dummy example
    data_mat <- BreastCancer[,c("Class","Cl.thickness","Cell.size","Cell.shape","Marg.adhesion")]
    col_counter <- ncol(data_mat)+1
    for(i in 2:ncol(data_mat)){
      for(val in unique(data_mat[,i])){
        data_mat[,col_counter] <- ifelse(data_mat[,i]==val,1,0)
        col_counter <- col_counter+1
      }
    }

    y <- data_mat[,"Class"]
    data_mat <- data_mat[,setdiff(colnames(data_mat),c("Class","Cl.thickness", "Cell.size",
                                                       "Cell.shape","Marg.adhesion"))]
    data_mat <- as.matrix(data_mat)

    model <- fastNaiveBayes.bernoulli(data_mat[1:400,], y[1:400], laplace = 1, sparse = TRUE)
    preds <- predict(model, newdata = data_mat[401:nrow(data_mat),], type = "class")

    mean(preds!=y[401:length(y)])

}
