% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{palettes}
\alias{palettes}
\title{Palette repair data}
\format{A data frame with 20 observations on the following 3 variables.
\itemize{ \item{palettes}{ number of palettes repaired}
\item{employee}{ a factor with levels \code{A} \code{B} \code{C}
\code{D}} \item{day}{ a factor with levels \code{day1} \code{day2}
\code{day3} \code{day4} \code{day5}} }}
\source{
Michael Stob, Calvin College
}
\description{
The palettes data set contains data from a firm that recycles palettes.
Palettes from warehouses are bought, repaired, and resold. (Repairing a
palette typically involves replacing one or two boards.) The company has
four employees who do the repairs. The employer sampled five days for each
employee and recorded the number of palettes repaired.
}
\examples{
data(palettes)
# Do the employees differ in the rate at which they repair palettes?
pal.lm1 <- lm(palettes~employee,palettes)
anova(pal.lm1)
# Now using day as a blocking variable
pal.lm2 <- lm(palettes~employee+day,palettes)
anova(pal.lm2)
xyplot(palettes~day, data=palettes,
		groups=employee,
		main="Productivity by day and employee",
		type='b',auto.key=list(columns=4,points=FALSE,lines=TRUE))
}
\keyword{datasets}

