% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normal.R
\name{normal}
\alias{normal}
\title{Normal Distribution Test}
\usage{
normal(x, num.names)
}
\arguments{
\item{x}{numerica object or dataframe and matrix}

\item{num.names}{numeric column names for dataframe and matrix. If missing,
all numeric column names will be given.}
}
\value{
a dataframe containing kurtosis, skewness and p value for Jarque
    Bera test, shapiro wilk test and Kolmogorov Smirnov test. In star column,
    star represents p > 0.05, while underline taking the opposite.
}
\description{
Using Jarque Bera test, shapiro wilk test and Kolmogorov Smirnov
    test for one numeric object or numeric object in dataframe or matrix. Na
    is omitted in each object.
}
\examples{
set.seed(2019)
rn1=rnorm(100,0,2)
df=data.frame(rn1=rnorm(100,0,2),
              rn2=rnorm(100,2,4))
#normal test for one object
normal(rn1)

#normal test for dataframe
normal(df)
}
