% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fasttext_interface.R
\name{plot_progress_logs}
\alias{plot_progress_logs}
\title{Plot the progress of loss, learning-rate and word-counts}
\usage{
plot_progress_logs(path_logs = "progress_data.txt", plot = FALSE)
}
\arguments{
\item{path_logs}{a character string specifying a valid path to a file where the progress-logs are saved}

\item{plot}{a boolean specifying if the loss, learning-rate and word-counts should be plotted}
}
\value{
an object of class data.frame that includes the progress logs with columns 'progress', 'words_sec_thread', 'learning_rate' and 'loss'
}
\description{
Plot the progress of loss, learning-rate and word-counts
}
\examples{

\dontrun{

library(fastText)

#-----------------------------------------------------------------
# the 'progress_data.txt' file corresponds to the 'path_output'
# parameter of the 'fasttext_interface()'. Therefore the user has
# to run first the 'fasttext_interface()' function to save the
# 'progress_data.txt' file to the desired folder.
#-----------------------------------------------------------------

res = plot_progress_logs(path = file.path(tempdir(), "progress_data.txt"),
                         plot = TRUE)

}
}
\references{
http://www.cookbook-r.com/Graphs/Multiple_graphs_on_one_page_(ggplot2)/
}
