% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mo_dwt.R
\name{mo_dwt}
\alias{mo_dwt}
\title{Maximal Overlap Discrete Wavelet Transform (MODWT)}
\usage{
mo_dwt(X, wavelet, decomp_level)
}
\arguments{
\item{X}{An (N x 1) matrix or a vector}

\item{wavelet}{Scaling filter name (see Details below) (string)}

\item{decomp_level}{Decomposition level (integer, 1 < decomp_level < N/2)}
}
\value{
Wavelet and scaling coefficients (N x J+1)
(wavelet coefficients in first J columns of returned matrix)
}
\description{
This function calculates the wavelet and scaling coefficients of the
MODWT.
}
\details{
The argument \code{wavelet} can take one of the following values:

\code{c("haar", "d1", "sym1", "d2", "sym2", "d3", "sym3", "d4", "d5", "d6", "d7", "d8", "d9", "d10", "d11", "sym4", "sym5", "sym6", "sym7", "sym8", "sym9", "sym10", "coif1", "coif2", "coif3", "coif4", "coif5", "la8", "la10", "la12", "la14", "la16", "la18", "la20", "bl14", "bl18", "bl20", "fk4", "fk6", "fk8", "fk14", "fk18", "fk22", )}
}
\examples{
N <- 1000 #  number of time series points
J <- 4 # decomposition level
wavelet <- 'coif1' # wavelet filter
X <- matrix(rnorm(N),N,1)
W <- mo_dwt(X,wavelet,J)
}
\references{
M. Basta (2014), Additive Decomposition and Boundary Conditions in Wavelet-Based
Forecasting Approaches, Acta Oeconomica Pragensia, 2, pp. 48-70.

Percival, D. B. and A. T. Walden (2000) Wavelet Methods for Time Series Analysis, Cambridge
University Press.
}
