% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{masked_approximation_impl}
\alias{masked_approximation_impl}
\title{Expand an SVD only at observed values of a sparse matrix}
\usage{
masked_approximation_impl(U, V, row, col)
}
\arguments{
\item{U}{Low-rank matrix of left singular-ish vectors.}

\item{V}{Low-rank matrix of right singular-ish vectors.}

\item{row}{Zero-based row indices of observed elements.}

\item{col}{Zero-based col indices of observed elements.}
}
\value{
A sparse matrix representing the low-rank reconstruction
from \code{U}, \code{d} and \code{V}, only at the index pairs indicated by
\code{row} and \code{col}.
}
\description{
TODO: describe what it looks like for dimensions to match up between
\code{s} and \code{mask}. See \code{vignette("sparse-computations")} for mathematical
details.
}
\details{
The idea is to populate \code{U}, \code{d} and \code{V} with using the
elements of an SVD-like list. You can generate \code{row} and \code{col}
most easily from a sparse masking Matrix (Matrix package),
coercing to triplet format, and extracting \code{mask@i} for \code{row}
and \code{mask@j} for column.
}
\keyword{internal}
