% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastcpd_wrappers.R
\name{fastcpd.mean}
\alias{fastcpd.mean}
\alias{fastcpd_mean}
\title{Find change points efficiently in mean change models}
\usage{
fastcpd.mean(data, ...)

fastcpd_mean(data, ...)
}
\arguments{
\item{data}{A matrix, a data frame or a vector.}

\item{...}{Other arguments passed to \code{\link{fastcpd}}, for example,
\code{segment_count}.}
}
\value{
A class \code{fastcpd} object.
}
\description{
\code{"fastcpd_mean"} and \code{"fastcpd.mean"} are wrapper
functions of \code{\link{fastcpd}} to find the mean change. The function is
similar to \code{"fastcpd"} except that the data is by default a matrix or
data frame or a vector with each row / element as an observation and thus a
formula is not required here.
}
\examples{
if (!requireNamespace("mvtnorm", quietly = TRUE)) utils::install.packages(
  "mvtnorm", repos = "https://cloud.r-project.org", quiet = TRUE
)

set.seed(1)
p <- 3
data <- rbind(
  mvtnorm::rmvnorm(300, mean = rep(0, p), sigma = diag(100, p)),
  mvtnorm::rmvnorm(400, mean = rep(50, p), sigma = diag(100, p)),
  mvtnorm::rmvnorm(300, mean = rep(2, p), sigma = diag(100, p))
)
result <- fastcpd.mean(data)
summary(result)
}
