% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{rasterZoneAnalyzer}
\alias{rasterZoneAnalyzer}
\title{Recognizes zones in the raster matrix and return a list of their analysis.}
\usage{
rasterZoneAnalyzer(raster, from = 0, to = 1, step = 0.1)
}
\arguments{
\item{raster}{input matrix of numeric values.}

\item{from}{lower (greater than) margin for recognizable zone values.}

\item{to}{upper (less than or equal) margin.}

\item{step}{values gradient.}
}
\value{
matrix of zones by four values: fill (ceiling values), weight (in cells), x and y of the mass center.
}
\description{
Takes a raster matrix and recognize zones exactly as the raster2vector function does. However does not return
polygon vectors, but weight and center of mass for each polygone (or so called zone).
}
\examples{
library(datasets)
rasterZoneAnalyzer(volcano, 120, 200, 20)
}
