% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_data.R
\name{generate_glmpca_data_pois}
\alias{generate_glmpca_data_pois}
\title{Generate Data from a GLM-PCA Model}
\usage{
generate_glmpca_data_pois(n, p, K, link = c("log", "log1p"))
}
\arguments{
\item{n}{Number of rows (genes).}

\item{p}{Number of columns (cells).}

\item{K}{Rank of the underlying mean structure.}

\item{link}{Character vector describing the link between the product 
of the loading and factors and the mean of the data.}
}
\value{
list with the following components
\itemize{
  \item LL - loadings of underlying mean structure. A K x n matrix
  \item FF - factors of underlying mean structure. A K x p matrix
  \item Y - n x p matrix of generated data.
}
}
\description{
Generate data from a GLM-PCA model with a specified
  rank.
}
\details{
This function assumes that each column of the data is generated
  from a multinomial distribution. Let \deqn{Y_j} denote column j of the 
  generated data matrix. First, we set \deqn{sum(Y_j)} equal to a value 
  generated from a \deqn{Uniform(50, 5000)} distribution. Then,
  we generate \deqn{L} and \deqn{F} from mixture distributions,
  and calculate \deqn{H = exp(L'F)}. Then, we generate the individual
  elements of \deqn{Y_j} from a multinomial model where the probability
  for each individual element is just \deqn{H_j} normalized.
}
\examples{
set.seed(1)
sim_data <- generate_glmpca_data_pois(1000, 500, 1)

}
