% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastqueue.R
\name{fastqueue}
\alias{fastqueue}
\title{Create a queue}
\usage{
fastqueue(init = 20, missing_default = NULL)
}
\arguments{
\item{init}{Initial size of the list that backs the queue. This is also used
as the minimum size of the list; it will not shrink any smaller.}

\item{missing_default}{The value to return when \code{remove()} or \code{peek()} are
called when the stack is empty. Default is \code{NULL}.}
}
\description{
A \code{fastqueue} is backed by a list, which is used in a circular manner. The
backing list will grow or shrink as the queue changes in size.
}
\details{
\code{fastqueue} objects have the following methods:

\describe{
\item{\code{add(x)}}{
Add an object to the queue.
}
\item{\code{madd(..., .list = NULL)}}{
Add objects to the queue. \code{.list} can be a list of objects to add.
}
\item{\code{remove(missing = missing_default)}}{
Remove and return the next object in the queue, but do not remove it from
the queue. If the queue is empty, this will return \code{missing}, which
defaults to the value of \code{missing_default} that \code{queue()} was created
with (typically, \code{NULL}).
}
\item{\code{remove(n, missing = missing_default)}}{
Remove and return the next \code{n} objects on the queue, in a list. The first
element of the list is the oldest object in the queue (in other words,
the next item that would be returned by \code{remove()}). If \code{n} is greater
than the number of objects in the queue, any requested items beyond
those in the queue will be replaced with \code{missing} (typically, \code{NULL}).
}
\item{\code{peek(missing = missing_default)}}{
Return the next object in the queue but do not remove it from the queue.
If the queue is empty, this will return \code{missing}.
}
\item{\code{reset()}}{
Reset the queue, clearing all items.
}
\item{\code{size()}}{
Returns the number of items in the queue.
}
\item{\code{as_list()}}{
Return a list containing the objects in the queue, where the first
element in the list is oldest object in the queue (in other words, it is
the next item that would be returned by \code{remove()}), and the last element
in the list is the most recently added object.
}
}
}
