% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_data.R
\name{prepare_data}
\alias{prepare_data}
\title{Prepare Data Function}
\usage{
prepare_data(
  train_data,
  test_data,
  label,
  impute_method = "medianImpute",
  encode_categoricals = TRUE,
  scaling_methods = c("center", "scale")
)
}
\arguments{
\item{train_data}{Training data frame.}

\item{test_data}{Testing data frame.}

\item{label}{Name of the target variable.}

\item{impute_method}{Method for missing value imputation. Default is \code{"medianImpute"}.
Options include \code{"medianImpute"}, \code{"knnImpute"}, \code{"bagImpute"}, or \code{NULL} for no imputation.}

\item{encode_categoricals}{Logical indicating whether to encode categorical variables. Default is \code{TRUE}.}

\item{scaling_methods}{Vector of scaling methods to apply. Options include \code{"center"}, \code{"scale"}, \code{"range"}, \code{"zv"}, \code{"nzv"}, \code{"YeoJohnson"}, \code{"BoxCox"}.
Default is \code{c("center", "scale")}.}
}
\value{
A list containing preprocessed training and testing data and the preprocessor object.
}
\description{
Preprocesses the training and testing data with customizable steps.
}
\keyword{internal}
