% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sanitize.R
\name{sanitize}
\alias{sanitize}
\title{Clean Column Names or Character Vectors by Removing Special Characters}
\usage{
sanitize(x)
}
\arguments{
\item{x}{A data frame or character vector to be cleaned.}
}
\value{
\itemize{
  \item If \code{x} is a data frame: returns a data frame with cleaned column names.
  \item If \code{x} is a character vector: returns a character vector with cleaned elements.
}
}
\description{
This function can operate on either a data frame or a character vector:
\itemize{
  \item \strong{Data frame}: Detects columns whose names contain any character
        that is not a letter, number, or underscore,
        removes colons, replaces slashes with underscores, and spaces
        with underscores.
  \item \strong{Character vector}: Applies the same cleaning rules to every
        element of the vector.
}
}
