% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/net.erdos.renyi.gnm.R
\name{net.erdos.renyi.gnm}
\alias{net.erdos.renyi.gnm}
\title{Directed / Undirected Erdos-Renyi \eqn{G(n,m)} network using a fix edge size.}
\usage{
net.erdos.renyi.gnm(n, m, ncores = detectCores(), d = TRUE)
}
\arguments{
\item{n}{Number of nodes of the network.}

\item{m}{Number of edges of the network.}

\item{ncores}{Number of cores, by default \code{detectCores()} from \code{parallel}.}

\item{d}{A logical value determining whether is a network directed (default) or indirected.}
}
\value{
A list containing the nodes of the network and their respective neighbors.
}
\description{
Simulate a random network with \emph{n} nodes and \emph{m} edges, according to Erdos and Renyi (1959).
}
\details{
In this (simplest) random network, \emph{m} edges are formed at random among \emph{n} nodes.
When \code{d = TRUE} is a directed network.
}
\examples{
\dontrun{
x <- net.erdos.renyi.gnm(1000, 100) }
}
\author{
Xu Dong, Nazrul Shaikh.
}
\references{
Erdos, P. and Renyi, A., On random graphs, Publicationes Mathematicae 6, 290-297 (1959).
}

