% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metric.cluster.global.R
\name{metric.cluster.global}
\alias{metric.cluster.global}
\title{Global Clustering Coefficient}
\usage{
metric.cluster.global(g)
}
\arguments{
\item{g}{The input network.}
}
\value{
A real constant.
}
\description{
Calculate the global clustering coefficient of a graph.
}
\details{
The global clustering coefficient measures the ratio of (closed) triples versus the total number of all possible triples in network \emph{g}. \code{metric.cluster.global()} calculates the global clustering coefficient of \emph{g}.
}
\examples{
\dontrun{
x <-  net.erdos.renyi.gnp(1000, 0.01)
metric.cluster.global(x)}
}
\references{
Wasserman, Stanley, and Katherine Faust. Social network analysis: Methods and applications. Vol. 8. Cambridge university press, 1994.
}
\author{
Xu Dong, Nazrul Shaikh.
}
