% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rnorm_multi.R
\name{rnorm_multi}
\alias{rnorm_multi}
\title{Multiple correlated normal distributions}
\usage{
rnorm_multi(
  n = 100,
  vars = NULL,
  mu = 0,
  sd = 1,
  r = 0,
  varnames = NULL,
  empirical = FALSE,
  as.matrix = FALSE,
  seed = NULL
)
}
\arguments{
\item{n}{the number of samples required}

\item{vars}{the number of variables to return}

\item{mu}{a vector giving the means of the variables (numeric vector of length 1 or vars)}

\item{sd}{the standard deviations of the variables (numeric vector of length 1 or vars)}

\item{r}{the correlations among the variables (can be a single number, vars\*vars matrix, vars\*vars vector, or a vars\*(vars-1)/2 vector)}

\item{varnames}{optional names for the variables (string vector of length vars) defaults if r is a matrix with column names}

\item{empirical}{logical. If true, mu, sd and r specify the empirical not population mean, sd and covariance}

\item{as.matrix}{logical. If true, returns a matrix}

\item{seed}{DEPRECATED use set.seed() instead}
}
\value{
a tbl of vars vectors
}
\description{
Make normally distributed vectors with specified relationships. See \href{../doc/rnorm_multi.html}{\code{vignette("rnorm_multi", package = "faux")}} for details.
}
\examples{
# 4 10-item vectors each correlated r = .5
rnorm_multi(10, 4, r = 0.5)

# set r with the upper right triangle
b <- rnorm_multi(100, 3, c(0, .5, 1), 1, 
                 r = c(0.2, -0.5, 0.5), 
                 varnames=c("A", "B", "C"))
cor(b)

# set r with a correlation matrix and column names from mu names
c <- rnorm_multi(
  n = 100, 
  mu = c(A = 0, B = 0.5, C = 1),
  r = c( 1,   0.2, -0.5, 
         0.2, 1,    0.5, 
        -0.5, 0.5,  1)
)
cor(c)

}
