% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixed-bond.R
\name{fixed_bond}
\alias{fixed_bond}
\title{Create Fixed Bond Object}
\usage{
fixed_bond(value_date, mty_date, redem_value, cpn_rate, cpn_freq)
}
\arguments{
\item{value_date, mty_date}{the value and maturity date of the bond}

\item{redem_value, cpn_rate, cpn_freq}{the redemption value, coupon rate and coupon frequency of the bond.
Note that the \strong{frequency} can only be one of 1, 2, 4, 0 (pay at mature)}
}
\value{
it returns an environment containing the following objects:
\itemize{
\item \code{.self}: an external pointer of the Rust object.
\item \code{len()}: a function returns the length of the internal bonds object.
\item \code{ytm_dur(ref_date, clean_price)}: a function returns a data.frame, with three columns,
'YTM' (Yield to Maturity), 'MODD' (Modified Duration) and 'MACD' (Macaulay Duration).
\item \code{cf(ref_date)}: a function returns the schedualed bond cashflows, in \code{xts} format.
}
}
\description{
Create Fixed Bond Object
}
\note{
\itemize{
\item all arguments must be the same length or 1.
\item The date input will be converted to Date object via \code{\link[ymd:ymd]{ymd::ymd()}}.
}

\itemize{
\item It doesn't take the day count convention into account for now.
\item There's no support for business day calendar. The dates in the cashflow projection are the
same days in the next few months (see \code{\link[ymd:edate]{ymd::edate()}}). It considers different days in each
month but no weekend date adjustment.
\item The 'YTM' value is the cashflow's 'IRR' (internal rate of return) value. Thus, it doesn't
equal to the Excel's Yield value, which is adjusted using this formula
\eqn{YTM (fcl) = (1 + frac{Yield (Excel)}{n})^n - 1},
where n is the the coupon payment frequency, when the remaining life of the bond is larger
than 1.
\item When the bond is going to mature within one year, the \eqn{Yield (Excel) = frac{Cashflow}{Price} - 1}.
}
}
\examples{
bond <- fixed_bond(
  value_date = 210101,
  mty_date = c(250101, 300201),
  redem_value = 100,
  cpn_rate = c(0.05, 0.03),
  cpn_freq = c(0, 1)
)
bond$ytm_dur(
  ref_date = c(220101, 220201),
  clean_price = 100
)
bond$cf(
  ref_date = c(220101, 220131)
)
}
