% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_misc.R
\name{fct_combine}
\alias{fct_combine}
\title{Combine Two Vectors of Unequal Lengths and Sort Based on Specified Levels}
\usage{
fct_combine(vector1, vector2, sort_by = 1, decreasing = FALSE)
}
\arguments{
\item{vector1}{The first vector to combine.}

\item{vector2}{The second vector to combine.}

\item{sort_by}{An integer (1 or 2) indicating which vector's levels to use for sorting. Default is \code{1}.}

\item{decreasing}{Logical. Should the sorting be in decreasing order? Default is \code{FALSE}.}
}
\value{
A factor vector combining both vectors and sorted based on specified levels.
}
\description{
Combines two vectors, which may be of unequal lengths, into a factor vector and sorts based on the levels of either the first or second vector.
}
\examples{
# Example vectors of unequal lengths
vector1 <- c('apple', 'banana', 'cherry')
vector2 <- c('date', 'fig', 'grape', 'honeydew')

# Combine and sort based on vector1 levels
combined_factor1 <- fct_combine(vector1, vector2, sort_by = 1)
print(combined_factor1)

# Combine and sort based on vector2 levels
combined_factor2 <- fct_combine(vector1, vector2, sort_by = 2)
print(combined_factor2)

# Combine with decreasing order based on vector1
combined_factor3 <- fct_combine(vector1, vector2, sort_by = 1, decreasing = TRUE)
print(combined_factor3)
}
