% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_misc.R
\name{fct_decode}
\alias{fct_decode}
\title{Decode Numeric Codes into Factor Levels}
\usage{
fct_decode(codes, mapping)
}
\arguments{
\item{codes}{A numeric vector of codes to decode.}

\item{mapping}{A named vector where names are levels and values are codes.}
}
\value{
A factor vector with decoded levels.
}
\description{
Converts numeric codes back into factor levels using a provided mapping.
}
\examples{
# Numeric codes
codes <- c(1, 2, 3, 2)

# Mapping from levels to codes
mapping <- c('low' = 1, 'medium' = 2, 'high' = 3)

# Decode codes into factor levels
fct_decode(codes, mapping = mapping)
}
\author{
Kai Guo
}
