% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{image.FEM}
\alias{image.FEM}
\title{Image Plot of a 2D FEM object}
\usage{
\method{image}{FEM}(x, num_refinements, ...)
}
\arguments{
\item{x}{A 2D-mesh \code{FEM} object.}

\item{num_refinements}{A natural number specifying how many bisections should by applied to each triangular element for
plotting purposes. This functionality is useful where a discretization with 2nd order Finite Element is applied.}

\item{...}{Arguments representing  graphical options to be passed to \link[rgl]{plot3d}.}
}
\description{
Image plot of a \code{FEM} object, generated by the function \code{FEM} or returned by
\code{smooth.FEM} and \code{FPCA.FEM}. Only FEM objects defined over a 2D mesh can be plotted with this method.
}
\examples{
library(fdaPDE)
## Upload the horseshoe2D data
data(horseshoe2D)
boundary_nodes = horseshoe2D$boundary_nodes
boundary_segments = horseshoe2D$boundary_segments
locations = horseshoe2D$locations

## Create the 2D mesh
mesh = create.mesh.2D(nodes = rbind(boundary_nodes, locations), segments = boundary_segments)
## Create the FEM basis
FEMbasis = create.FEM.basis(mesh)
## Compute the coeff vector evaluating the desired function at the mesh nodes
## In this case we consider the fs.test() function introduced by Wood et al. 2008
coeff = fs.test(mesh$nodes[,1], mesh$nodes[,2])
## Create the FEM object
FEMfunction = FEM(coeff, FEMbasis)

## Plot the FEM function
image(FEMfunction)
}
\seealso{
\code{\link{FEM}} \code{\link{plot.FEM}}
}
