% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/POIFD.R
\name{POIFD}
\alias{POIFD}
\title{Integrated Depth for Partially Observed Functional Data}
\usage{
POIFD(data, type = c("MBD", "FMD", "MHRD"), phi)
}
\arguments{
\item{data}{matrix p by n, being n the number of functions and p the number of grid points.
Rownames are the dense grid x and colnames the identifier of each functional data.}

\item{type}{chosen depth measure. Fraiman and Muniz depth (\code{"FMD"}), Modified band depth (\code{"MBD"})
or Modified Half Region Depth and Modified Epigraph/Hipograph Index \code{"MHRD"})}

\item{phi}{phi function of weights for the POIFD. The default value is as in the paper, i.e. the proportion of observed functions
at each time point.}
}
\value{
Ordered vector of depths from the deepest to outward. The names are the functions names (if provided)
or the column position.
}
\description{
Compute the depth measures of a partially observed functional data set evaluated in a common grid.
}
\examples{
data <- gaussian_PoFD(n=100, p=200, type="sparse", observability=0.5)$pofd
poifd <- POIFD(data,  type = c("MBD"))

}
