% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparsePOFD.R
\name{sparsePOFD}
\alias{sparsePOFD}
\title{Sparse Observability}
\usage{
sparsePOFD(data, observability = NULL, pIncomplete = NULL)
}
\arguments{
\item{data}{functional data completely observed. pxn matrix being n the number of curves and p the number og evaluation points.}

\item{observability}{observed proportion of the domain where each function is observed.}

\item{pIncomplete}{number between 0 and 1 related to the proportion of curves that suffers partially observability.
The default is 1 meaning that all the sample curves are partially observed.}
}
\value{
a list containing two elements 1) a functional sample and 2) the same sample of functions but
partially observed following one of the schemes described in the argument type.
}
\description{
Generates samples of sparse functions. See Elías et al (2020).
}
\examples{

data <- sapply(1:100, function(x) runif(1)*sin(seq(0, 2*pi, length.out = 200)) +
runif(1)*cos(seq(0, 2*pi, length.out = 200)))

data_pofd <- sparsePOFD(data, observability = 0.5, pIncomplete = 1)

}
\references{
Elías, Antonio, Jiménez, Raúl, Paganoni, Anna M. and Sangalli, Laura M. (2020). Integrated Depths for Partially Observed Functional Data.
}
