% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FVPA.R
\name{FVPA}
\alias{FVPA}
\title{Functional Variance Process Analysis for sparse or dense functional data}
\usage{
FVPA(y, t, q = 0.1, optns = list())
}
\arguments{
\item{y}{A list of \emph{n} vectors containing the observed values for each individual. Missing values specified by \code{NA}s are supported for dense case (\code{dataType='dense'}).}

\item{t}{A list of \emph{n} vectors containing the observation time points for each individual corresponding to y.}

\item{q}{A scalar defining the percentile of the pooled sample residual sample used for adjustment before taking log (default: 0.1).}

\item{optns}{A list of options control parameters specified by \code{list(name=value)}. See `Details in ?FPCA'.}
}
\value{
A list containing the following fields:
\item{sigma2}{Variance estimator of the functional variance process.} 
\item{fpcaObjY}{FPCA object for the original data.} 
\item{fpcaObjR}{FPCA object for the functional variance process associated with the original data.}
}
\description{
Functional Variance Process Analysis for sparse or dense functional data
}
\examples{
set.seed(1)
n <- 20
pts <- seq(0, 1, by=0.05)
sampWiener <- Wiener(n, pts)
sampWiener <- Sparsify(sampWiener, pts, 10) 
#fvpaObj <- FVPA(sampWiener$yList, sampWiener$tList)
}
\references{
\cite{Hans-Georg Mueller, Ulrich Stadtmuller and Fang Yao, "Functional variance processes." Journal of the American Statistical Association 101 (2006): 1007-1018}
}

