% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/q_to_curve.R
\name{q_to_curve}
\alias{q_to_curve}
\title{Convert to curve space}
\usage{
q_to_curve(q, scale = 1)
}
\arguments{
\item{q}{either a matrix of shape \eqn{n \times T} describing SRVF or SRVF of
multidimensional functional data in \eqn{R^n}, where \eqn{n} is the dimension
and \eqn{T} is the number of time points}

\item{scale}{scale of from curve_to_q (default = \code{1})}
}
\value{
beta array describing curve
}
\description{
This function converts SRVFs to curves
}
\examples{
q <- curve_to_q(beta[, , 1, 1])$q
beta1 <- q_to_curve(q)
}
\references{
Srivastava, A., Klassen, E., Joshi, S., Jermyn, I., (2011). Shape analysis of elastic curves in euclidean spaces. Pattern Analysis and Machine Intelligence, IEEE Transactions on 33 (7), 1415-1428.
}
\keyword{alignment}
\keyword{srvf}
