% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classif_com.R
\name{classifier-com}
\alias{classif.com}
\alias{classifier-com}
\alias{predict.classif.com}
\title{Functional data classifier via concentration inequalities}
\usage{
classif.com(datGrp, dat)

\method{predict}{classif.com}(object, dat, SOFT = FALSE, LOADING = FALSE,
  ...)
}
\arguments{
\item{datGrp}{A vector of group labels.}

\item{dat}{(n X m) data matrix of n samples
of m long vectors.}

\item{object}{A concentration-of-measure classifier object
of class inheriting from \code{classif.com}.}

\item{SOFT}{Boolean flag, which if TRUE, returns soft
classification for each observation.}

\item{LOADING}{Boolean flag, which if TRUE, prints
a loading bar.}

\item{...}{additional arguments affecting the predictions produced.}
}
\value{
\code{classif.com} returns a functional data classifier
        object.  \code{predict.classif.com} returns a vector
        of n labels ( or an array of n probability vectors if  
        SOFT=TRUE )
}
\description{
\code{classif.com} trains a covariance operator based 
functional data classifier that makes use of concentration inequalities.  
\code{predict.classif.com} uses the previously trained classifier
to classify new observations.
}
\details{
These functions are used to train a functional data classifier
and to predict the labels for a new set of observations.
This method classifies based on the distances between each 
groups' sample covariance operator.  A simplified version of
Talagrand's concentration inequality is used to achieve this.

If the flag SOFT is set to TRUE, then soft classification occurs.
In this case, given k different labels, a k-long probability vector
is returned for each observation whose entries correspond to the 
probabilities that the observed function belongs to each specific label.
}
\examples{
\dontrun{
 library(fds);
 # Setup training data
 dat1 = rbind( 
   t(aa$y[,1:100]), t(ao$y[,1:100]), t(dcl$y[,1:100]), 
   t(iy$y[,1:100]), t(sh$y[,1:100]) 
 );
 # Setup testing data
 dat2 = rbind( 
   t(aa$y[,101:400]), t(ao$y[,101:400]), t(dcl$y[,101:400]), 
   t(iy$y[,101:400]), t(sh$y[,101:400]) 
 );
 
 datgrp = gl(5,100);
 clCom = classif.com( datgrp, dat1 );
 grp = predict( clCom, dat2, LOADING=TRUE );
 acc = c(
   sum( grp[1:300]==1 ), sum( grp[301:600]==2 ), sum( grp[601:900]==3 ), 
   sum( grp[901:1200]==4 ), sum( grp[1201:1500]==5 )
 )/300;
 print(rbind(gl(5,1),signif(acc,3)));
}
\dontshow{
 library(fds);
 # Setup training data
 dat1 = rbind( 
   t(aa$y[,1:5]), t(ao$y[,1:5]), t(dcl$y[,1:5]) 
 );
 # Setup testing data
 dat2 = rbind( 
   t(aa$y[,11:15]), t(ao$y[,11:15]), t(dcl$y[,11:15])
 );
 
 datgrp = gl(3,5);
 clCom = classif.com( datgrp, dat1 );
 grp = predict( clCom, dat2 );
}
}
\author{
Adam B Kashlak \email{ak852@cam.ac.uk}
}
\references{
Kashlak, Adam B, John AD Aston, and Richard Nickl (2016).
  "Inference on covariance operators via concentration
  inequalities: k-sample tests, classification, and clustering via
  Rademacher complexities", (in review)
}

