% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classification.R
\name{evaluation.accuracy}
\alias{evaluation.accuracy}
\title{Accuracy of classification predictions}
\usage{
evaluation.accuracy(predictions, targets, ...)
}
\arguments{
\item{predictions}{The predictions of a classification model (\code{factor} or \code{vector}).}

\item{targets}{Actual targets of the dataset (\code{factor} or \code{vector}).}

\item{...}{Other parameters.}
}
\value{
The evaluation of the predictions (numeric value).
}
\description{
Evaluation predictions of a classification model according to accuracy.
}
\examples{
require (datasets)
data (iris)
d = splitdata (iris, 5)
model.nb = NB (d$train.x, d$train.y)
pred.nb = predict (model.nb, d$test.x)
evaluation.accuracy (pred.nb, d$test.y)
}
\seealso{
\code{\link{evaluation.fmeasure}}, \code{\link{evaluation.fowlkesmallows}}, \code{\link{evaluation.goodness}}, \code{\link{evaluation.jaccard}}, \code{\link{evaluation.kappa}}, \code{\link{evaluation.precision}},
\code{\link{evaluation.precision}}, \code{\link{evaluation.recall}},
\code{\link{evaluation}}
}
