% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature.R
\name{selectfeatures}
\alias{selectfeatures}
\title{Feature selection for classification}
\usage{
selectfeatures(
  train,
  labels,
  algorithm = c("ranking", "forward", "backward", "exhaustive"),
  unieval = if (algorithm[1] == "ranking") c("fisher", "fstat", "relief",
    "inertiaratio") else NULL,
  uninb = NULL,
  unithreshold = NULL,
  multieval = if (algorithm[1] == "ranking") NULL else c("mrmr", "cfs", "fstat",
    "inertiaratio", "wrapper"),
  wrapmethod = NULL,
  keep = FALSE,
  ...
)
}
\arguments{
\item{train}{The training set (description), as a \code{data.frame}.}

\item{labels}{Class labels of the training set (\code{vector} or \code{factor}).}

\item{algorithm}{The feature selection algorithm.}

\item{unieval}{The (univariate) evaluation criterion. \code{uninb}, \code{unithreshold} or \code{multieval} must be specified.}

\item{uninb}{The number of selected feature (univariate evaluation).}

\item{unithreshold}{The threshold for selecting feature (univariate evaluation).}

\item{multieval}{The (multivariate) evaluation criterion.}

\item{wrapmethod}{The classification method used for the wrapper evaluation.}

\item{keep}{If true, the dataset is kept in the returned result.}

\item{...}{Other parameters.}
}
\description{
Select a subset of features for a classification task.
}
\examples{
require (datasets)
data (iris)
selectfeatures (iris [, -5], iris [, 5], algorithm = "forward", multieval = "fstat")
selectfeatures (iris [, -5], iris [, 5], algorithm = "ranking", uninb = 2)
selectfeatures (iris [, -5], iris [, 5], algorithm = "ranking",
                multieval = "wrapper", wrapmethod = LDA)
}
\seealso{
\code{\link{FEATURESELECTION}}, \code{\link{selection-class}}
}
