% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset.R
\name{data.gauss}
\alias{data.gauss}
\title{Gaussian mixture dataset}
\usage{
data.gauss(
  n = 1000,
  k = 2,
  prob = rep(1/k, k),
  mu = cbind(rep(0, k), seq(from = 0, by = 3, length.out = k)),
  cov = rep(list(matrix(c(6, 0.9, 0.9, 0.3), ncol = 2, nrow = 2)), k),
  levels = NULL,
  graph = TRUE,
  seed = NULL
)
}
\arguments{
\item{n}{Number of observations.}

\item{k}{The number of classes.}

\item{prob}{The a priori probability of each class.}

\item{mu}{The means of the gaussian distributions.}

\item{cov}{The covariance of the gaussian distributions.}

\item{levels}{Name of each class.}

\item{graph}{A logical indicating whether or not a graphic should be plotted.}

\item{seed}{A specified seed for random number generation.}
}
\value{
A randomly generated dataset.
}
\description{
Generate a random multidimentional gaussian mixture.
}
\examples{
data.gauss ()
}
\seealso{
\code{\link{data.diag}}, \code{\link{data.parabol}}, \code{\link{data.target2}}, \code{\link{data.twomoons}}, \code{\link{data.xor}}
}
