% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text.R
\name{predict.textmining}
\alias{predict.textmining}
\title{Model predictions}
\usage{
\method{predict}{textmining}(object, test, fuzzy = FALSE, ...)
}
\arguments{
\item{object}{The classification model (of class \code{\link{textmining-class}}, created by \code{\link{TEXTMINING}}.}

\item{test}{The test set (a \code{data.frame})}

\item{fuzzy}{A boolean indicating whether fuzzy classification is used or not.}

\item{...}{Other parameters.}
}
\value{
A vector of predicted values (\code{factor}).
}
\description{
This function predicts values based upon a model trained for text mining.
}
\examples{
\dontrun{
require (text2vec)
data ("movie_review")
d = movie_review [, 2:3]
d [, 1] = factor (d [, 1])
d = splitdata (d, 1)
model = TEXTMINING (d$train.x, NB, labels = d$train.y, mincount = 50)
pred = predict (model, d$test.x)
evaluation (pred, d$test.y)
}
}
\seealso{
\code{\link{TEXTMINING}}, \code{\link{textmining-class}}
}
