% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_entity.R
\name{add_entity}
\alias{add_entity}
\title{add_entity}
\usage{
add_entity(entityset, entity_id, df, index = NULL, time_index = NULL,
  ...)
}
\arguments{
\item{entityset}{The entity set to modify.}

\item{entity_id}{The name of the entity to add.}

\item{df}{The data frame to add as an entity.}

\item{index}{The index parameter specifies the column that uniquely identifies rows in the dataframe}

\item{time_index}{Name of the time column in the dataframe.}

\item{...}{Additional parameters passed to `featuretools.entity_from_dataframe`.}
}
\value{
A modified entityset.
}
\description{
Add an entity to an entityset.
}
\examples{
\donttest{
library(magrittr)
create_entityset("set") \%>\%
  add_entity(df = cars,
             entity_id = "cars",
             index = "row_number")
}
}
