% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/febr2sf.R
\name{febr2sf}
\alias{febr2sf}
\title{Create an sf object}
\usage{
febr2sf(obj)
}
\arguments{
\item{obj}{Object of class \code{data.frame} downloaded from the Data Repository of the Brazilian Soil
using \code{\link[=observation]{observation()}}.}
}
\value{
An object of class \code{sfc_POINT} (single soil observation) or \code{sfc_MULTIPOINT} (multiple
soil observations).
}
\description{
Set spatial coordinates and coordinate reference system (CRS) to a set of soil
observations.
}
\details{
Create an sf object from the
\emph{observation} ("observacao") table of one or more standardized datasets contained in the FEBR
Soil Data Repository, \url{https://www.pedometria.org/febr/}.
}
\examples{
if (interactive()) {
res <- observation(
  data.set = "ctb0013",
  progress = FALSE, verbose = FALSE)
res <- febr2sf(obj = res)
plot(res["geometry"], axes = TRUE, graticule = TRUE)
}
}
\references{
Pebesma, E., 2018. Simple Features for R: Standardized Support for Spatial Vector Data.
The R Journal 10 (1), 439-446, \doi{10.32614/RJ-2018-009}
}
\author{
Alessandro Samuel-Rosa \email{alessandrosamuelrosa@gmail.com}
}
