% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_effort.R
\name{calc_fishing_effort}
\alias{calc_fishing_effort}
\title{Calculate days at sea and fishing days for a full trip data set.}
\usage{
calc_fishing_effort(dat, check_data = TRUE)
}
\arguments{
\item{dat}{data.frame with the details of all the fishing trips.}

\item{check_data}{Should the \code{\link{check_format}} function be called on the data first (default is TRUE).
It is not possible to run \code{\link{check_format}} with automatic corrections here. Do this yourself first.}
}
\value{
A list with two data.frames: one with the fishing days by gear, fishing area, economic zone and rectangle,
the other with the days at sea by gear, fishing area and economic zone.
}
\description{
Calculates the days at sea and the fishing days for each trip in a data set.
}
\details{
The input is a \code{data.frame} that contains details of fishing trips.
The format of the data should be checked by \code{\link{check_format}} before calling this function 
(see the package vignette \emph{checking_data} for more details on the data format).
See the documentation of \code{\link{calc_fishing_days_trip}} and \code{\link{calc_days_at_sea_trip}}
and the vignette \emph{calculating_fishing_effort} for more details
of how the different effort measures are calculated.
This function has the additional option of calling \code{\link{check_format}} before
the calculations are performed.
}
\examples{
trip1 <- data.frame(
    eunr_id = "my_boat", loa = 2000, gt = 70, kw = 400,
    trip_id = "trip1",
    # 4 day trip
    depdate = "20140718", deptime = "0615", retdate = "20140721", rettime = "1615",
    # Only fish on 2 of those
    fishdate = c("20140719", "20140719", "20140719", "20140719", "20140720",
       "20140720", "20140720"), 
    gear = c("OTB","OTB","OTB","GN","OTB","GN","FPO"), gear_mesh_size = c(80,80,80,50,80,50,0),
    fishing_area = "27.4.B",
    economic_zone = "EU",
    rectangle = c("39F0","40F0","41F0","41F0","41F0","41F0","41F0"),
    stringsAsFactors = FALSE
)
trip2 <- data.frame(
    eunr_id = "my_boat", loa = 2000, gt = 70, kw = 400,
    trip_id = "trip2",
    # 2 day trip
    depdate = "20140718", deptime = "0615", retdate = "20140719", rettime = "0600",
    # Only fish on 2 of those
    fishdate = c("20140718", "20140719", "20140719", "20140719"), 
    gear = c("OTB","OTB","GN","FPO"), gear_mesh_size = c(80,80,50,0),
    fishing_area = "27.4.B",
    economic_zone = "EU",
    rectangle = c("39F0","39F0"),
    stringsAsFactors = FALSE
)
dat <- rbind(trip1, trip2)
effort <- calc_fishing_effort(dat)
}
\seealso{
See \code{\link{check_format}}.
See the package vignette \emph{checking_data} for data preparation
and the vignette \emph{calculating_fishing_effort} for the calculation
details.
}

