% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_effort.R
\name{calc_fishing_days_trip}
\alias{calc_fishing_days_trip}
\title{Calculate fishing days for a fishing trip.}
\usage{
calc_fishing_days_trip(trip)
}
\arguments{
\item{trip}{Data.frame of the trip data}
}
\value{
A data.frame with the fishing days by gear, fishing area, economic zone and rectangle.
}
\description{
Calculate fishing days for a single fishing trip using data in the format
described in the package vignette \emph{checking_data}.
}
\details{
The input is a single fishing trip. The format of the data should be
checked by \code{\link{check_format}} before calling this function 
(see the package vignette \emph{checking_data} for more details).
Fishing days is reported at the gear (type and mesh size), fishing area, economic zone and rectangle level.
Passive and active gears are treated separately.
For active gears, each fishing date has 1 fishing day that is spread equally over the active gears.
For passive gears, each use of a passive gear is one fishing day, i.e. on fishing date can have several passive fishing days simultaneously.
See the vignette \emph{calculating_fishing_effort} for more details.
This function is called by \code{\link{calc_fishing_effort}}.
}
\examples{
trip1 <- data.frame(
   eunr_id = "my_boat", loa = 2000, gt = 70, kw = 400,
   trip_id = "trip1",
   # 4 day trip
   depdate = "20140718", deptime = "0615", retdate = "20140721", rettime = "1615",
   # Only fish on 2 of those
   fishdate = c("20140719", "20140719", "20140719", "20140719", "20140720",
       "20140720", "20140720"), 
   gear = c("OTB","OTB","OTB","GN","OTB","GN","FPO"), gear_mesh_size = c(80,80,80,50,80,50,0),
   fishing_area = "27.4.B",
   economic_zone = "EU",
   rectangle = c("39F0","40F0","41F0","41F0","41F0","41F0","41F0"),
   stringsAsFactors = FALSE
)
fd <- calc_fishing_days_trip(trip1)
}
\seealso{
See \code{\link{calc_fishing_effort}}.
See the package vignette \emph{checking_data} for data preparation
and the vignette \emph{calculating_fishing_effort} for the calculation
details.
}
