% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fe_projects_search.R
\name{fe_projects_search}
\alias{fe_projects_search}
\title{Search Federal RePORTER Projects}
\usage{
fe_projects_search(project_number = NULL, fiscal_year = NULL, text = NULL,
  text_field = c("title", "abstract", "terms"), text_operator = c("AND",
  "OR"), agency = NULL, pi_name = NULL, offset = 1, limit = 50,
  verbose = TRUE, secure = TRUE)
}
\arguments{
\item{project_number}{unique number that is assigned to a project
by the affiliated federal agency. Examples, 5R01MH092950-05,
1R01CA183929-01A1, USFS-0000779.
Can also use wildcards such as \code{*R01*}.}

\item{fiscal_year}{Fiscal year of data to obtain}

\item{text}{Search text from title, abstract, and terms data}

\item{text_field}{text field to search, can be title, abstract or terms,
and defaults to search all. Only enabled when \code{text} is not \code{NULL}.}

\item{text_operator}{Text operator to combine text terms,
Can be AND or OR, AND is default.
Only enabled when \code{text} is not \code{NULL}.}

\item{agency}{Agency code to search.  see \code{\link{fe_agencies}}}

\item{pi_name}{Principal investigator name.  Names are to be in the
\code{Last First M}, \code{Last, First}, \code{First},
\code{Last}, or \code{First Last} formats.  Multiple names can be
given.}

\item{offset}{start at item # (starts at 1)}

\item{limit}{max # of items to return (at the most 50 per request)}

\item{verbose}{print diagnostic messages}

\item{secure}{Should https be used, passed to \code{\link{fe_base_url}}}
}
\value{
List of the result of the \code{\link{GET}} call and
the content
}
\description{
Search Federal RePORTER Projects
}
\examples{
res = fe_projects_search(
project_number = "USFS*",
fiscal_year = 2012)
res = fe_projects_search(
project_number = "*R01*",
fiscal_year = 2012,
agency = "NIH",
text = "stroke",
text_field = "title")

\dontrun{
res = fe_projects_search(pi_name = "MATSUI, ELIZABETH")
items = res$content$items
con_pis = sapply(items, "[[", "contactPi")
keep = grepl("^MATSUI", con_pis)
items = items[keep]
mat_costs = sapply(items, "[[", "totalCostAmount")
sum(mat_costs)

res = fe_projects_search(pi_name = "PENG, ROGER")
items = res$content$items
con_pis = sapply(items, "[[", "contactPi")
keep = grepl("^PENG", con_pis)
items = items[keep]
peng_costs = sapply(items, "[[", "totalCostAmount")
sum(peng_costs)

both = fe_projects_search(
pi_name = c("MATSUI, ELIZABETH", "PENG, ROGER"))
}
}
