\name{MonteCarlo}
\alias{read.crl}
\alias{plot.crl}
\alias{print.crl}

\title{Monte Carlo simulations}
\description{
  Using Monte Carlo in FEMME a .crl file is generated which
  can be read and further processed with these functions
}

\usage{
read.crl(crlfile)

\method{plot}{crl}(x,xvari=2,yvari=3,type='p',pch=".",main=x$filename,xlab=NULL,ylab=NULL,
                     mar=NULL,oma=NULL,size=1,\dots)

\method{print}{crl}(x,\dots)

}
\arguments{
  \item{crlfile}{File ending in .crl generated by FEMME}
  \item{x}{object of class crl created by \code{read.crl}}
  \item{xvari}{Index of X Variables}
  \item{yvari}{Index of Y Variables}
  \item{main}{Main title}
  \item{xlab}{X axis label}
  \item{ylab}{Y axis label}
  \item{mar}{Inner margins}
  \item{oma}{Outer margins}
  \item{type}{Plot type}
  \item{pch}{Plot symbol}
  \item{size}{Relative size of labels}
  \item{...}{Additional plot parameters}
}
\details{

}
\value{

\code{read.crl} returns a crl object

}
\references{Soetaert et al, 2002, Ecological  Modelling 151: 177-193}

\author{Karline Soetaert <k.soetaert@nioo.knaw.nl>}
\note{Use at your own risk}


\examples{

## For examples see: vignette("femmeR")

}

\keyword{file}
\keyword{misc}
\keyword{hplot}

