% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fergm_beta_traceplot.R
\name{fergm_beta_traceplot}
\alias{fergm_beta_traceplot}
\title{Plot traceplots for model terms.}
\usage{
fergm_beta_traceplot(fergm.fit = NULL, custom_var_names = NULL,
  form = NULL)
}
\arguments{
\item{fergm.fit}{Output object from the fergm function.}

\item{custom_var_names}{If custom variable names are to be used, specify a vector of characters equal to the number of terms used.}

\item{form}{The right hand side formula specified for the FERGM function, custom.var.names takes precedent.}
}
\value{
This prints a traceplot for the effects of interest
}
\description{
This function takes a fergm object and plots the time series of each chain per model term.
}
\examples{
# load example data
data("ergm.fit")
data("fergm.fit")
data("mesa")
# Use rstan's built in traceplot function
trace <- rstan::traceplot(fergm.fit$stan.fit, pars = "beta")
trace

# We have our own version that includes variable names and tidies it up a bit
fergm_beta_traceplot(fergm.fit,
                    form = NULL,
                    custom_var_names =  c("Edges", "Sex Homophily",
                    "Grade Homophily", "Race Homophily", "GWESP", "Alternating K-Stars"))
}
\references{
Box-Steffensmeier, Janet M., Dino P. Christenson, and Jason W. Morgan. 2017. ``Modeling Unobserved Heterogeneity in Social Networks with the Frailty Exponential Random Graph Model." \emph{Political Analysis}.

Stan Development Team (2016). RStan: the R interface to Stan. R package version 2.14.1. \url{http://mc-stan.org/}.
}
\keyword{FERGM}
\keyword{interpret}
\keyword{summary}
